capture log close
clear all
macro drop _all
cd "C:\Users\alice\Quantonomics Dropbox\Quantonomics Team Folder\AER25\1. Opex Function Development\Input substitution\Stata\3. Opex Cost Function\Econometric Analysis\Scenario w1"
set more off
set maxiter 300

**** SET PERIOD ***
local perd "long"      // can be "long" or "short"

log using Output/log/anOpexReg24-logprice-`perd', replace text

display "Models: `perd'"

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function - Input Substitution Project
								
Author:  Michael Cunningham (based on a Denis Lawrence program)
		    with modifications by Joe Hirschberg & Alice Giovani
File:    anOpexReg24-IS.do
Initial Date:    4-Jul-2022
Revised Date:	 4-Jun-2025

--------------------------------------------------------------------------*/
tempfile data data1

* Period & dependent variable
if "`perd'" == "long" {
	local startyr 2006
	}
else if "`perd'" == "short" {
	local startyr 2012
}
local endyr   2023

* 
scalar define ppp_aust   		   = 1.527404363
scalar define ppp_nz    		   = 1.482877481
scalar define ppp_canada		   = 1.249076963

scalar define propex_rebase_aust   = 1.238501756
scalar define propex_rebase_nz     = 1.219668445
scalar define propex_rebase_canada = 1.160126855  

* Read data
use Input/DNSPopex24_InputSubs, clear
xtset eiid year

gen int dnsp = eiid - 1000 if country == 1
qui tabulate dnsp, gen(d)
forvalues k = 1/13 {
	replace d`k' = 0 if d`k' == .
}

tabulate country, gen(jur)
correlate custnum circlen rmdem shareugc
tabulate year

summarize d* jur*

* Sample selection
*-------------------------

drop if country == 3 & year < (`startyr' - 1)
drop if country < 3 & year < `startyr'
drop if country == 3 & year > (`endyr' - 1)
drop if country < 3 & year > `endyr'

* Modify & create variables
*--------------------------

* Adressing change of VIC's DNSP from calendar to financial year in 2021
generate yr=year
replace yr=yr+0.5 if dnsp==3 & year<2021
replace yr=yr+0.5 if dnsp==8 & year<2021
replace yr=yr+0.5 if dnsp==9 & year<2021
replace yr=yr+0.5 if dnsp==11 & year<2021
replace yr=yr+0.5 if dnsp==13 & year<2021
replace yr=yr-0.25 if country==2
replace yr=yr+0.5 if country==3

replace propex = propex / propex_rebase_aust    if country==1
replace propex = propex / propex_rebase_nz      if country==2
replace propex = propex / propex_rebase_canada  if country==3
replace propex = propex * ppp_nz / ppp_aust     if country==2
replace propex = propex * ppp_canada / ppp_aust if country==3

*gen lastob = 0
*replace lastob = 1 if dnsp != dnsp[_n+1]


* Regression log variables
gen lvc = log(opex / propex)
gen ly1 = log(custnum)
gen ly2 = log(circlen)
gen ly3 = log(rmdem)
gen lz1 = log(shareugc)

gen lratioprice = log(ratioprice)

* mean correct output data
qui reg ly1
predict mly1
replace ly1=ly1-mly1
qui reg ly2
predict mly2
replace ly2=ly2-mly2
qui reg ly3
predict mly3
replace ly3=ly3-mly3

* TLG variables
gen ly11 = (ly1^2)/2
gen ly12 = ly1*ly2
gen ly13 = ly1*ly3
gen ly22 = (ly2^2)/2
gen ly23 = ly2*ly3
gen ly33 = (ly3^2)/2


* Labels
label variable ly1  "ln(Custnum)=x1" 
label variable ly2  "ln(CircLen)=x2" 
label variable ly3  "ln(ten_yrs_rmd)=x3" 
label variable lz1  "ln(ShareUGC)" 
label variable ly11 "x1*x1/2" 
label variable ly12 "x1*x2" 
label variable ly13 "x1*x3" 
label variable ly22 "x2*x2/2" 
label variable ly23 "x2*x3" 
label variable ly33 "x3*x3/2"
label variable yr   "Year" 
label variable jur2 "New Zealand" 
label variable jur3 "Ontario" 
label variable d2   "AGD" 
label variable d3   "CIT" 
label variable d4   "END" 
label variable d5   "ENX" 
label variable d6   "ERG"
label variable d7   "ESS" 
label variable d8   "JEN" 
label variable d9   "PCR" 
label variable d10  "SAP"
label variable d11  "AND" 
label variable d12  "TND" 
label variable d13  "UED"

* Regression models
*---------------------- 

*================================
* 1. LSECD
*================================

xtpcse lvc ly1 ly2 ly3 lz1 lratioprice yr jur2 jur3 d2-d13, c(a) het
estimates store LSECD

* Pseudo-adjusted R2
scalar k_lsecd = 21 		
predict yhat, xb
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_lsecd))	
display "LSECD Pseudo-adjusted R2 = " `psadjr2'

gen eh = lvc - yhat

iqr eh
swilk eh
collin ly1 ly2 ly3 lz1 yr jur2 jur3 d2-d13 lratioprice


* Efficiency scores

predictnl eff1 = 1/ max(1, 1/exp(_b[d2]), 1/exp(_b[d3]), 1/exp(_b[d4]), ///
  1/exp(_b[d5]), 1/exp(_b[d6]), 1/exp(_b[d7]), 1/exp(_b[d8]), 1/exp(_b[d9]), ///
  1/exp(_b[d10]), 1/exp(_b[d11]), 1/exp(_b[d12]), 1/exp(_b[d13])), ///
  ci(eff1_lb  eff1_ub)
gen eff    = eff1    if dnsp == 1
gen eff_lb = eff1_lb if dnsp == 1
gen eff_ub = eff1_ub if dnsp == 1

		
forvalues i = 2/13 {
  predictnl eff`i' = 1/exp(_b[d`i']) / max(1, 1/exp(_b[d2]), 1/exp(_b[d3]), ///
  1/exp(_b[d4]), 1/exp(_b[d5]), 1/exp(_b[d6]), 1/exp(_b[d7]), 1/exp(_b[d8]), ///
  1/exp(_b[d9]), 1/exp(_b[d10]), 1/exp(_b[d11]), 1/exp(_b[d12]), ///
  1/exp(_b[d13])), ci(eff`i'_lb  eff`i'_ub)
  
  replace eff    = eff`i'    if dnsp == `i'
  replace eff_lb = eff`i'_lb if dnsp == `i'
  replace eff_ub = eff`i'_ub if dnsp == `i'		
}

drop eff1  eff1_lb  eff1_ub  eff2  eff2_lb  eff2_ub  eff3  eff3_lb  eff3_ub ///
	eff4  eff4_lb  eff4_ub  eff5  eff5_lb  eff5_ub  eff6  eff6_lb  eff6_ub ///
	eff7  eff7_lb  eff7_ub  eff8  eff8_lb  eff8_ub  eff9  eff9_lb  eff9_ub ///
	eff10 eff10_lb eff10_ub eff11 eff11_lb eff11_ub eff12 eff12_lb eff12_ub ///
	eff13 eff13_lb eff13_ub 

* Output elasticities	

predictnl ely1 = (_b[ly1]), ci(lw_y1 up_y1)
predictnl ely2 = (_b[ly2]), ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3]), ci(lw_y3 up_y3)
predictnl elY  = (_b[ly1] + _b[ly2] + _b[ly3]), ci(lw_Y up_Y)

* Tabulation

table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD", replace)

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A8)

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A39)
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A46)	
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSECD") cell(A46)	

drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 elY lw_Y up_Y ///
	eff eff_lb eff_ub yhat eh


*================================
* 2. LSETLG
*================================

xtpcse lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 lratioprice yr jur2 jur3 ///
	d2-d13, c(a) het
estimates store LSETLG
predict yhat, xb
test ly11 ly12 ly13 ly22 ly23 ly33

* Pseudo-adjusted R2
scalar k_lsetlg = 27 		
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_lsetlg))	
display "LSETLG Pseudo-adjusted R2 = " `psadjr2'

gen eh = lvc - yhat
iqr eh
swilk eh
collin ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr jur2 jur3 ///
	   d2-d13 lratioprice


* Efficiency scores

predictnl eff1 = 1/ max(1, 1/exp(_b[d2]), 1/exp(_b[d3]), 1/exp(_b[d4]), ///
  1/exp(_b[d5]), 1/exp(_b[d6]), 1/exp(_b[d7]), 1/exp(_b[d8]), 1/exp(_b[d9]), ///
  1/exp(_b[d10]), 1/exp(_b[d11]), 1/exp(_b[d12]), 1/exp(_b[d13])), ///
  ci(eff1_lb  eff1_ub)
gen eff    = eff1    if dnsp == 1
gen eff_lb = eff1_lb if dnsp == 1
gen eff_ub = eff1_ub if dnsp == 1

		
forvalues i = 2/13 {
  predictnl eff`i' = 1/exp(_b[d`i']) / max(1, 1/exp(_b[d2]), 1/exp(_b[d3]), ///
  1/exp(_b[d4]), 1/exp(_b[d5]), 1/exp(_b[d6]), 1/exp(_b[d7]), 1/exp(_b[d8]), ///
  1/exp(_b[d9]), 1/exp(_b[d10]), 1/exp(_b[d11]), 1/exp(_b[d12]), ///
  1/exp(_b[d13])), ci(eff`i'_lb  eff`i'_ub)
  
  replace eff    = eff`i'    if dnsp == `i'
  replace eff_lb = eff`i'_lb if dnsp == `i'
  replace eff_ub = eff`i'_ub if dnsp == `i'		
}

drop eff1  eff1_lb  eff1_ub  eff2  eff2_lb  eff2_ub  eff3  eff3_lb  eff3_ub ///
	eff4  eff4_lb  eff4_ub  eff5  eff5_lb  eff5_ub  eff6  eff6_lb  eff6_ub ///
	eff7  eff7_lb  eff7_ub  eff8  eff8_lb  eff8_ub  eff9  eff9_lb  eff9_ub ///
	eff10 eff10_lb eff10_ub eff11 eff11_lb eff11_ub eff12 eff12_lb eff12_ub ///
	eff13 eff13_lb eff13_ub 

* Output elasticities	
	
predictnl ely1 = (_b[ly1] + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3), ///
	ci(lw_y1 up_y1) p(p1)
predictnl ely2 = (_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3), ///
	ci(lw_y2 up_y2) p(p2)
predictnl ely3 = (_b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ///
	ci(lw_y3 up_y3) p(p3)
predictnl elY  = (_b[ly1]  + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 + ///
	_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 + _b[ly3] + ///
	_b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ci(lw_Y up_Y)

* Tabulation

table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG", replace)

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A8)

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A39)
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A46)

table (dnsp) (var), stat(mean ely1 lw_y1 up_y1)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A53)
	
table (dnsp) (var), stat(mean ely2 lw_y2 up_y2)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A70)
	
table (dnsp) (var), stat(mean ely3 lw_y3 up_y3)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("LSETLG") cell(A87)
	
	
display "MONOTONICITY VIOLATIONS"
gen mon1 = 0
gen mon2 = 0
gen mon3 = 0
gen montot = 0
replace mon1 = cond(ely1 < 0,1,0)	
replace mon2 = cond(ely2 < 0,1,0)	
replace mon3 = cond(ely3 < 0,1,0)
replace montot = 1 if mon1 == 1 | mon2 == 1 | mon3 == 1


tabstat mon1 mon2 mon3 montot, by(country) statistics(mean)
tabstat mon1 mon2 mon3 montot if dnsp <= 13, by(dnsp) statistics(mean) 


* exporting elasticity data to excel 

export excel eiid year country custnum rmdem circlen ely1 ely2 ely3 ///
	  using Output/xlsx/monotonicity-`perd'.xlsx, ///
	sheet("lsetlg", replace) firstrow(var) 	

drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 elY lw_Y up_Y ///
	eff eff_lb eff_ub mon1 mon2 mon3 montot eh  ///
	 p1 p2 p3 yhat

	
*================================
* 3. SFACD
*================================

constraint 1 _b[mu:_cons] == 0

qui reg lvc ly1 ly2 ly3 lz1 lratioprice yr jur2 jur3
matrix b0 = e(b), ln(e(rmse)^2) , .1, .1
xtfrontier lvc ly1 ly2 ly3 lz1 lratioprice yr jur2 jur3, cost from(b0, copy) ti ///
	diff  // constraints(1)
estimates store SFACD

* STATS TESTS
predict yhat1, xb
predict yhat2, u
gen yhat = yhat1 + yhat2	
gen eh = lvc - yhat
estat ic

scalar k_sfacd = 11 		
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_sfacd))	
display "SFACD Pseudo-adjusted R2 = " `psadjr2'

iqr eh
swilk eh
collin ly1 ly2 ly3 lz1 yr jur2 jur3 lratioprice

predict tec, te
frontier_teci tec
generate eff = 1/tec
generate eff_lb = 1/tec_u
generate eff_ub = 1/tec_l

display "EFFICIENCY SCORES"
tabstat eff eff_lb eff_ub if dnsp <= 13, by(dnsp) statistics(mean)

* Output elasticities	

predictnl ely1 = (_b[ly1]), ci(lw_y1 up_y1)
predictnl ely2 = (_b[ly2]), ci(lw_y2 up_y2)
predictnl ely3 = (_b[ly3]), ci(lw_y3 up_y3)
predictnl elY  = (_b[ly1] + _b[ly2] + _b[ly3]), ci(lw_Y up_Y)

* Tabulation

table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD", replace)

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A8)

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A39)
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFACD") cell(A46)	
		
drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 elY lw_Y up_Y ///
	eff eff_lb eff_ub tec tec_u tec_l yhat1 yhat2 yhat eh


*================================
* 4. SFATLG
*================================

qui reg lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 lratioprice yr jur2 jur3
matrix b0 = e(b) 
matrix b0 = e(b), ln(e(rmse)^2) , .1, .1
xtfrontier lvc ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 lratioprice yr jur2 jur3, ///
	cost from(b0, copy) ti diff  // constraints(1)
estimates store SFATLG

* STATS TESTS
predict yhat1, xb
predict yhat2, u
gen yhat = yhat1 + yhat2	
gen eh = lvc - yhat
estat ic

scalar k_sfatlg = 17		
qui corr lvc yhat
local psadjr2 = 1 - ((1 - r(rho)^2)*(r(N) - 1)/(r(N) - k_sfacd))	
display "SFATLG Pseudo-adjusted R2 = " `psadjr2'

iqr eh
swilk eh
collin ly1 ly2 ly3 ly11 ly12 ly13 ly22 ly23 ly33 lz1 yr jur2 jur3 lratioprice

test ly11 ly12 ly13 ly22 ly23 ly33


predict tec, te
frontier_teci tec
generate eff = 1/tec
generate eff_lb = 1/tec_u
generate eff_ub = 1/tec_l

display "EFFICIENCY SCORES"
tabstat eff eff_lb eff_ub if dnsp <= 13, by(dnsp) statistics(mean)

* Output elasticities	
	
predictnl ely1 = (_b[ly1] + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3), ///
	ci(lw_y1 up_y1) p(p1)
predictnl ely2 = (_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3), ///
	ci(lw_y2 up_y2) p(p2)
predictnl ely3 = (_b[ly3] + _b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ///
	ci(lw_y3 up_y3) p(p3)
predictnl elY  = (_b[ly1]  + _b[ly11]*ly1 + _b[ly12]*ly2 + _b[ly13]*ly3 + ///
	_b[ly2] + _b[ly12]*ly1 + _b[ly22]*ly2 + _b[ly23]*ly3 + _b[ly3] + ///
	_b[ly13]*ly1 + _b[ly23]*ly2 + _b[ly33]*ly3), ci(lw_Y up_Y)

* Tabulation

table (country) (var), stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG", replace)

table (dnsp) (var) if eiid < 2000, stat(mean eff eff_lb eff_ub)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A8)

table (country) (var), stat(mean ely1 lw_y1 up_y1)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A25)
	
table (country) (var), stat(mean ely2 lw_y2 up_y2)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A32)
	
table (country) (var), stat(mean ely3 lw_y3 up_y3)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A39)
	
table (country) (var), stat(mean elY lw_Y up_Y)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A46)	
	
	table (dnsp) (var), stat(mean ely1 lw_y1 up_y1)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A53)
	
table (dnsp) (var), stat(mean ely2 lw_y2 up_y2)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A70)
	
table (dnsp) (var), stat(mean ely3 lw_y3 up_y3)
collect export Output/xlsx/Stats-`perd'.xlsx, modify ///
	sheet("SFATLG") cell(A87)


display "MONOTONICITY VIOLATIONS"
gen mon1 = 0
gen mon2 = 0
gen mon3 = 0
gen montot = 0
replace mon1 = cond(ely1 < 0,1,0)	
replace mon2 = cond(ely2 < 0,1,0)	
replace mon3 = cond(ely3 < 0,1,0)
replace montot = 1 if mon1 == 1 | mon2 == 1 | mon3 == 1

gen hir1 = 0
gen hir2 = 0
gen hir3 = 0
gen hirtot = 0
replace hir1 = cond(ely1 < 0,1,0) if p1 < .05	
replace hir2 = cond(ely2 < 0,1,0) if p2 < .05	
replace hir3 = cond(ely3 < 0,1,0) if p3 < .05
replace hirtot = 1 if hir1 == 1 | hir2 == 1 | hir3 == 1

tabstat mon1 mon2 mon3 montot, by(country) statistics(mean)
tabstat mon1 mon2 mon3 montot if dnsp <= 13, by(dnsp) statistics(mean) 
tabstat hir1 hir2 hir3 hirtot, by(country) statistics(mean)
tabstat hir1 hir2 hir3 hirtot if dnsp <= 13, by(dnsp) statistics(mean)


gen v2 = (lvc - fit0 - fit1)^2
summarize v2
scalar define sev = sqrt(r(mean))
scalar list sev
gen studv = (lvc - fit0 - fit1)/sev
iqr studv
swilk studv

* exporting  monotonicity and elasticity data to excel 

export excel eiid year country custnum rmdem circlen ely1 ely2 ely3 ///
	v2 studv using Output/xlsx/monotonicity-`perd'.xlsx, ///
	sheet("sfatlg", replace) firstrow(var)
	 
drop ely1 lw_y1 up_y1 ely2 lw_y2 up_y2 ely3 lw_y3 up_y3 elY lw_Y up_Y ///
	eff eff_lb eff_ub mon1 mon2 mon3 montot hir1 hir2 hir3 hirtot v2 ///
	p1 p2 p3 fit0 fit1 yhat1 yhat2 yhat

* LR test
lrtest SFATLG SFACD


* Tabulating models
*--------------------

estout LSECD using Output/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("LSECD-`perd'") stats(r2 N, fmt(3)) replace
estout LSETLG using Output/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("LSETLG-`perd'") stats(r2 N, fmt(3)) append
estout SFACD using Output/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("SFACD-`perd'") stats(r2 N, fmt(3)) append
estout SFATLG using Output/tsv/Reg-`perd'.tsv, ///
	cells("b(fmt(3)) se(fmt(3)) t(fmt(3))") /// 
	style(tab) label title("SFATLG-`perd'") stats(r2 N, fmt(3)) append

drop _est_LSECD	_est_LSETLG	_est_SFACD	_est_SFATLG	
	
export excel using Output/xlsx/outputdata-`perd'.xlsx ///
	if eiid < 2000, firstrow(var) replace



log close
exit
